/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.BlobRef;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ClobRef;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.global.StringObject;
import com.mckoi.util.BigNumber;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CastHelper {
    private static BigNumber BD_ZERO = BigNumber.fromLong(0L);
    private static BigNumber BD_ONE = BigNumber.fromLong(1L);
    private static DateFormat[] date_format_sql = new DateFormat[1];
    private static DateFormat[] time_format_sql;
    private static DateFormat[] ts_format_sql;

    private static Object toJavaObject(Object ob) {
        try {
            return ObjectTranslator.serialize(ob);
        }
        catch (Throwable e) {
            throw new Error("Can't serialize object " + ob.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatDateAsString(Date d) {
        DateFormat[] dateFormatArray = ts_format_sql;
        synchronized (ts_format_sql) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ts_format_sql[1].format(d);
        }
    }

    private static String paddedString(String str, int size) {
        if (size == -1) {
            return str;
        }
        int dif = size - str.length();
        if (dif > 0) {
            StringBuffer buf = new StringBuffer(str);
            for (int n = 0; n < dif; ++n) {
                buf.append(' ');
            }
            return new String(buf);
        }
        if (dif < 0) {
            return str.substring(0, size);
        }
        return str;
    }

    private static Date toDate(long time) {
        return new Date(time);
    }

    private static BigNumber toBigNumber(String str) {
        try {
            return BigNumber.fromString(str);
        }
        catch (Throwable e) {
            return BD_ZERO;
        }
    }

    private static String dateErrorString(String msg, DateFormat[] df) {
        String pattern = "";
        if (df[0] instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)df[0];
            pattern = "(" + sdf.toPattern() + ")";
        }
        return msg + pattern;
    }

    public static Date toDate(String str) {
        DateFormat[] dateFormatArray = date_format_sql;
        synchronized (date_format_sql) {
            for (int i = 0; i < date_format_sql.length; ++i) {
                try {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return date_format_sql[i].parse(str);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            throw new RuntimeException(CastHelper.dateErrorString("Unable to parse string as a date ", date_format_sql));
        }
    }

    public static Date toTime(String str) {
        DateFormat[] dateFormatArray = time_format_sql;
        synchronized (time_format_sql) {
            for (int i = 0; i < time_format_sql.length; ++i) {
                try {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return time_format_sql[i].parse(str);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            throw new RuntimeException(CastHelper.dateErrorString("Unable to parse string as a time ", time_format_sql));
        }
    }

    public static Date toTimeStamp(String str) {
        DateFormat[] dateFormatArray = ts_format_sql;
        synchronized (ts_format_sql) {
            for (int i = 0; i < ts_format_sql.length; ++i) {
                try {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return ts_format_sql[i].parse(str);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            throw new RuntimeException(CastHelper.dateErrorString("Unable to parse string as a timestamp ", ts_format_sql));
        }
    }

    public static Object castObjectToSQLType(Object ob, int sql_type, int sql_size, int sql_scale, String sql_type_string) {
        if (ob instanceof ByteLongObject) {
            if (sql_type != 2000 && sql_type != 2004 && sql_type != -2 && sql_type != -3 && sql_type != -4) {
                try {
                    ob = ObjectTranslator.deserialize((ByteLongObject)ob);
                }
                catch (Throwable e) {
                    throw new Error("Can't cast a BLOB to " + sql_type_string);
                }
            } else {
                return ob;
            }
        }
        if (ob instanceof BlobRef && (sql_type == -2 || sql_type == 2004 || sql_type == 2000 || sql_type == -3 || sql_type == -4)) {
            return ob;
        }
        if (ob instanceof ClobRef && (sql_type == 12 || sql_type == -1 || sql_type == 2005)) {
            return ob;
        }
        if (ob == null) {
            switch (sql_type) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: 
                case 91: 
                case 92: 
                case 93: 
                case 2000: 
                case 2004: 
                case 2005: {
                    return null;
                }
            }
            throw new Error("Can't cast NULL to " + sql_type_string);
        }
        if (ob instanceof Number) {
            Number n = (Number)ob;
            switch (sql_type) {
                case -7: {
                    return n.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                }
                case -6: 
                case 4: 
                case 5: {
                    return BigNumber.fromLong(n.intValue());
                }
                case -5: {
                    return BigNumber.fromLong(n.longValue());
                }
                case 6: {
                    return BigNumber.fromString(Double.toString(n.doubleValue()));
                }
                case 7: {
                    return BigNumber.fromString(n.toString());
                }
                case 8: {
                    return BigNumber.fromString(Double.toString(n.doubleValue()));
                }
                case 2: 
                case 3: {
                    return BigNumber.fromString(n.toString());
                }
                case 1: {
                    return StringObject.fromString(CastHelper.paddedString(n.toString(), sql_size));
                }
                case 12: {
                    return StringObject.fromString(n.toString());
                }
                case -1: {
                    return StringObject.fromString(n.toString());
                }
                case 91: {
                    return CastHelper.toDate(n.longValue());
                }
                case 92: {
                    return CastHelper.toDate(n.longValue());
                }
                case 93: {
                    return CastHelper.toDate(n.longValue());
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return new ByteLongObject(n.toString().getBytes());
                }
                case 0: {
                    return null;
                }
                case 2000: {
                    return CastHelper.toJavaObject(ob);
                }
                case 16: {
                    return n.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                }
            }
            throw new Error("Can't cast number to " + sql_type_string);
        }
        if (ob instanceof StringObject || ob instanceof String) {
            String str = ob.toString();
            switch (sql_type) {
                case -7: {
                    return str.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                case -6: 
                case 4: 
                case 5: {
                    return BigNumber.fromLong(CastHelper.toBigNumber(str).intValue());
                }
                case -5: {
                    return BigNumber.fromLong(CastHelper.toBigNumber(str).longValue());
                }
                case 6: {
                    return BigNumber.fromString(Double.toString(CastHelper.toBigNumber(str).doubleValue()));
                }
                case 7: {
                    return CastHelper.toBigNumber(str);
                }
                case 8: {
                    return BigNumber.fromString(Double.toString(CastHelper.toBigNumber(str).doubleValue()));
                }
                case 2: 
                case 3: {
                    return CastHelper.toBigNumber(str);
                }
                case 1: {
                    return StringObject.fromString(CastHelper.paddedString(str, sql_size));
                }
                case 12: {
                    return StringObject.fromString(str);
                }
                case -1: {
                    return StringObject.fromString(str);
                }
                case 91: {
                    return CastHelper.toDate(str);
                }
                case 92: {
                    return CastHelper.toTime(str);
                }
                case 93: {
                    return CastHelper.toTimeStamp(str);
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return new ByteLongObject(str.getBytes());
                }
                case 0: {
                    return null;
                }
                case 2000: {
                    return CastHelper.toJavaObject(str);
                }
                case 16: {
                    return str.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2005: {
                    return StringObject.fromString(str);
                }
            }
            throw new Error("Can't cast string to " + sql_type_string);
        }
        if (ob instanceof Boolean) {
            Boolean b = (Boolean)ob;
            switch (sql_type) {
                case -7: {
                    return b;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return b.equals(Boolean.TRUE) ? BD_ONE : BD_ZERO;
                }
                case 1: {
                    return StringObject.fromString(CastHelper.paddedString(b.toString(), sql_size));
                }
                case 12: {
                    return StringObject.fromString(b.toString());
                }
                case -1: {
                    return StringObject.fromString(b.toString());
                }
                case 0: {
                    return null;
                }
                case 2000: {
                    return CastHelper.toJavaObject(ob);
                }
                case 16: {
                    return b;
                }
            }
            throw new Error("Can't cast boolean to " + sql_type_string);
        }
        if (ob instanceof Date) {
            Date d = (Date)ob;
            switch (sql_type) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return BigNumber.fromLong(d.getTime());
                }
                case 1: {
                    return StringObject.fromString(CastHelper.paddedString(CastHelper.formatDateAsString(d), sql_size));
                }
                case 12: {
                    return StringObject.fromString(CastHelper.formatDateAsString(d));
                }
                case -1: {
                    return StringObject.fromString(CastHelper.formatDateAsString(d));
                }
                case 91: {
                    return d;
                }
                case 92: {
                    return d;
                }
                case 93: {
                    return d;
                }
                case 0: {
                    return null;
                }
                case 2000: {
                    return CastHelper.toJavaObject(ob);
                }
            }
            throw new Error("Can't cast date to " + sql_type_string);
        }
        if (ob instanceof byte[]) {
            switch (sql_type) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return new ByteLongObject((byte[])ob);
                }
            }
            throw new Error("Can't cast byte[] to " + sql_type_string);
        }
        if (sql_type == 2000) {
            return CastHelper.toJavaObject(ob);
        }
        throw new RuntimeException("Can't cast object " + ob.getClass() + " to " + sql_type_string);
    }

    static {
        CastHelper.date_format_sql[0] = new SimpleDateFormat("yyyy-MM-dd");
        time_format_sql = new DateFormat[4];
        CastHelper.time_format_sql[0] = new SimpleDateFormat("HH:mm:ss.S z");
        CastHelper.time_format_sql[1] = new SimpleDateFormat("HH:mm:ss.S");
        CastHelper.time_format_sql[2] = new SimpleDateFormat("HH:mm:ss z");
        CastHelper.time_format_sql[3] = new SimpleDateFormat("HH:mm:ss");
        ts_format_sql = new DateFormat[4];
        CastHelper.ts_format_sql[0] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
        CastHelper.ts_format_sql[1] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        CastHelper.ts_format_sql[2] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        CastHelper.ts_format_sql[3] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

